
/*

Because the physique interface has changed between character studio 2.2 and 3,
we have to compile one version of these functions against the
character studio 2.2 headers (included in physique2.cpp)
and one version against the character studio 3 headers (included in physique3.cpp),
then link them up at run time against the physique.dlm version number via the 
RwExpPhysique class which will instance an RwExpPhysique2 or an RwExpPhysique3 as appropriate
to call these functions transparently.

Otherwise, despite being compile time compatible,
using IPhyExport & friends compiled from character studio 3 will crash when run against
version 2.x of physique.dlm and vice versa (even the GetVersion() method!!!).

Yes, this is ugly, but it is better logistically than shipping 2 builds of the exporter!

*/

static
BonesContainer * GetInfluentialBonesFromPhysique( INode *physiqueNode )
//get the bones used by this physique & put them in a new bones container,
//(could be empty if it doesn't have any!) or return 0 if there was an error
//(mostly a copy-paste of CSTDIO/SDK/PhyExportSample.cpp)
{
#ifdef CSSUPPORT
    Modifier *mod = FindPhysiqueModifier (physiqueNode);

    if (mod == 0)
    {
        //not a physique node, dumbass.
        return 0;
    }

    BonesContainer *bones = new BonesContainer();

	//get a pointer to the export interface
	IPhysiqueExport *phyExport = (IPhysiqueExport *)mod->GetInterface(I_PHYEXPORT);

	//get the physique version number.  
	//If the version number is > 30 you may have floating bones
	int ver = phyExport->Version();

	//get a pointer to the export context interface
	IPhyContextExport *mcExport = (IPhyContextExport *)phyExport->GetContextInterface(physiqueNode);

	//convert to rigid for time independent vertex assignment
	mcExport->ConvertToRigid(true);

	//allow blending to export multi-link assignments
	mcExport->AllowBlending(true);

	//get the vertex count from the export interface
	int numverts = mcExport->GetNumberVertices();
	
    INode* bone = 0;

	//iterate through all vertices and gather the bone list
    //(we check all of them because we can't handle floating bones properly yet,
    //so we should at least warn the user!)
	for (int i = 0; i<numverts; i++) 
	{
        //get the hierarchial vertex interface
        //n.b. when compiling against CharacterStudio 3's phyexp.h, this defaults to:
        //GetVertexInterface(i, HIERARCHIAL_VERTEX);
		IPhyVertexExport* vi = mcExport->GetVertexInterface(i);
		if (vi)
        {
            //check the vertex type and process accordingly
			int type = vi->GetVertexType();
			switch (type) 
			{
				//The vertex is rigid, blended vertex.  It's assigned to multiple links
                case RIGID_BLENDED_TYPE:
                {
					//type-cast the node to the proper class		
					IPhyBlendedRigidVertex *rb_vtx = (IPhyBlendedRigidVertex*)vi;
					//iterate through the bones assigned to this vertex
					for (int x = 0; x<rb_vtx->GetNumberNodes(); x++) 
					{
                        //get the node by index
						bone = rb_vtx->GetNode(x);
                        if (bone != 0)  //can be null if someone deleted it!
                        {
                            bones->insert( bone );
                        }
                    }
                }
                break; 
            	
                //The vertex is a rigid vertex and only assigned to one link
				case RIGID_TYPE:
                {
					//type-cast the node to the proper calss
					IPhyRigidVertex *r_vtx = (IPhyRigidVertex*)vi;
					
					//get the node
					bone = r_vtx->GetNode();
                    if (bone != 0)  //can be null if someone deleted it!
                    {
                        bones->insert( bone );
                    }
                }
                break;

                // Shouldn't make it here because we converted to rigid earlier.  
				// It should be one of the above two types
				default:
                {
	                //release the context interface
	                phyExport->ReleaseContextInterface(mcExport);

	                //Release the physique interface
	                mod->ReleaseInterface(I_PHYINTERFACE, phyExport);

                    throw RwExpError("Sorry, can't export physique vertex assignment type!");
                }
                break;
            } //switch
        } //if

#if (CURRENT_VERSION == 3)
        //Character Studio 3 - only Character Studio 2 doesn't have floating bones.
        //(Set by PhyExp.h - you will need to compile with the one that came with Character Studio 3)
        
        // After gathering the bones from the rigid vertex interface
		// gather all floating bones if there are any 
		IPhyFloatingVertex *f_vtx =
            (IPhyFloatingVertex*)mcExport->GetVertexInterface(i, FLOATING_VERTEX);
		if (f_vtx)
        {
            //We have a vertex assigned to a floating bone
			// iterate through the links assigned to this vertex
			for (int x = 0; x<f_vtx->GetNumberNodes(); x++)
			{
                //get the node by index
				bone = f_vtx->GetNode(x);
                
	            //release the context interface
	            phyExport->ReleaseContextInterface(mcExport);

	            //Release the physique interface
	            mod->ReleaseInterface(I_PHYINTERFACE, phyExport);

                throw RwExpError(
                    std::string("Sorry, but I can't export this character because it uses the node ") +
                    std::string(bone->GetName()) +
                    std::string(" which is a floating bone and I don't support those yet.")
                    );
            }
        }
#endif
    }

	//release the context interface
	phyExport->ReleaseContextInterface(mcExport);

	//Release the physique interface
	mod->ReleaseInterface(I_PHYINTERFACE, phyExport);

    return bones;
#else
    return 0;
#endif
}

static void
CalculateCSVertexBoneMap(INode *node, RwInt32 *vertexMap,
    const int CSNumBones, INode ** CSBoneIndexNodePointers,
    ReMapper & remapper,
    RwMatrixWeights  * & skinMatrixWeights, RwUInt32 *  & skinVertexIndices )
{
#ifdef CSSUPPORT
    int i;
                    
    /* now get data from physique */    
    Modifier *phyMod = FindPhysiqueModifier(node);    
    if (phyMod)    
    {
        IPhysiqueExport *phyExport = (IPhysiqueExport *)phyMod->GetInterface(I_PHYINTERFACE);
        
        if (phyExport)
        {                      
            /* create a ModContext Export Interface for the specific node of the Physique Modifier */
            IPhyContextExport *mcExport = (IPhyContextExport *)phyExport->GetContextInterface(node);

            if (mcExport)
            {
                /* we convert all vertices to Rigid in this example */
                mcExport->ConvertToRigid(TRUE);                
                mcExport->AllowBlending(TRUE);                
                skinMatrixWeights = (RwMatrixWeights *)RwMalloc(sizeof(RwMatrixWeights) * remapper.GetNumVertices());
                skinVertexIndices = (RwUInt32 *)RwMalloc(sizeof(RwUInt32) * remapper.GetNumVertices());

                for (i = 0; i < remapper.GetNumVertices(); i++)
                {                                
                    RwBool matchedVert = 0;
                    int vertexIndex = remapper.GetVertex(i)->vertexIndex;                                   
                    IPhyVertexExport *vtxExport = mcExport->GetVertexInterface(vertexIndex);

                    skinVertexIndices[vertexMap[i]] = 0;
                    skinMatrixWeights[vertexMap[i]].w0 = 0.0f;
                    skinMatrixWeights[vertexMap[i]].w1 = 0.0f;
                    skinMatrixWeights[vertexMap[i]].w2 = 0.0f;
                    skinMatrixWeights[vertexMap[i]].w3 = 0.0f;

                    if (vtxExport)
                    {		        		       	  
                        int j, k;                                
                        if (vtxExport->GetVertexType() == RIGID_BLENDED_TYPE)
                        {
			                IPhyBlendedRigidVertex *vtx = (IPhyBlendedRigidVertex *)vtxExport;
                            int numNodes = vtx->GetNumberNodes();
                            int numWeightsSet = 0;
                            RwBool moreThan4Weights = FALSE;
                                                        
                            for (k=0; k<numNodes; k++)
                            {
                                /* only add non zero weights to the weight array */
                                if (vtx->GetWeight(k)>0)
                                {
                                    INode *Bone = vtx->GetNode(k);

                                    for (j=0; j < CSNumBones; j++)
                                    {
                                        if (CSBoneIndexNodePointers[j] == Bone)
                                        {
                                            int wVert;
                                            RwBool matchedToWeight = FALSE;
                                            matchedVert = 1;
                                            /* first check if we already have a weighting for this
                                               vertex, if we do just increment the weight */
                                            for (wVert=0; wVert < numWeightsSet; wVert++)
                                            {
                                                if (j == (int)((skinVertexIndices[vertexMap[i]] >> (wVert*8)) & 0xff))
                                                {
                                                    void *weightArrayPtr = &(skinMatrixWeights[vertexMap[i]]); 
                                                    RwReal *weightArray = (RwReal *)weightArrayPtr;
                                                    weightArray[wVert] += vtx->GetWeight(k);
                                                    matchedToWeight = TRUE;
                                                }
                                            }
                                        
                                            if (!matchedToWeight)                                       
                                            {
                                                if (numWeightsSet < 4)
                                                {
                                                    skinVertexIndices[vertexMap[i]] |= j << (numWeightsSet*8);                                            
                                                    void *weightArrayPtr = &(skinMatrixWeights[vertexMap[i]]);
                                                    RwReal *weightArray = (RwReal *)weightArrayPtr;
                                                    weightArray[numWeightsSet] = vtx->GetWeight(k);                                                    
                                                    numWeightsSet++;
                                                }
                                                else
                                                {
                                                    moreThan4Weights = TRUE;
                                                }
                                            }
                                        }
                                    }
                                }
                            }                            

                            /* If there were more than 4 weights on this vertex re-scale the first 4. Should really pick the
                               4 highest and re-scale */
                            if (moreThan4Weights)
                            {
                                RwReal weightScale = 1.0f / (skinMatrixWeights[vertexMap[i]].w0+skinMatrixWeights[vertexMap[i]].w1+
                                                            skinMatrixWeights[vertexMap[i]].w2+skinMatrixWeights[vertexMap[i]].w3);
                                skinMatrixWeights[vertexMap[i]].w0 *= weightScale;
                                skinMatrixWeights[vertexMap[i]].w1 *= weightScale;
                                skinMatrixWeights[vertexMap[i]].w2 *= weightScale;
                                skinMatrixWeights[vertexMap[i]].w3 *= weightScale;
                            }
                        }
                        else
                        {
                            IPhyRigidVertex *vtxNoBlend = (IPhyRigidVertex *)vtxExport;
                            INode *Bone = vtxNoBlend->GetNode();
                            int numNodes = 1;

                            for (k=0; k<numNodes; k++)
                            {
                                INode *Bone = vtxNoBlend->GetNode();

                                for (j=0; j < CSNumBones; j++)
                                {
                                    if (CSBoneIndexNodePointers[j] == Bone)
                                    {
                                        matchedVert = 1;
                                        skinVertexIndices[vertexMap[i]] |= j;
                                    }
                                }                                                
                                skinMatrixWeights[vertexMap[i]].w0 = 1.0f;
                            }
                        }
                         
                        mcExport->ReleaseVertexInterface(vtxExport);                        
                        vtxExport = NULL;
                            
                    }                            
                    assert(matchedVert == 1); 
                    assert((skinMatrixWeights[vertexMap[i]].w0+skinMatrixWeights[vertexMap[i]].w1+
                           skinMatrixWeights[vertexMap[i]].w2+skinMatrixWeights[vertexMap[i]].w3) < 1.2f);
                }                     
            }                 
            phyExport->ReleaseContextInterface(mcExport);            
        }        
        phyMod->ReleaseInterface(I_PHYINTERFACE, phyExport);                    
    }                 
    
#else /* CSSUPPORT */

#endif /* CSSUPPORT */
}
